﻿var editWorkFlow = {
    context: $(".v-editWorkflow"),
    workflowId: 0,
    workflowItems: [],
    datatable: null,
    initialize: function () {
        editWorkFlow.workflowId = $("#Id").val();
        editWorkFlow.initializeWorkflowItems();
        a4.initializeInputs(editWorkFlow.context);
    },
    initializeWorkflowItems: function () {
        a4.callServerMethod(a4.getAction("GetWorkFlowItems", "MultiMode", "Settings"),
            { "workflowId": editWorkFlow.workflowId },
            function (result) {
                _.each(result, function (item, index) {
                    item.TempId = index + 1;
                });

                editWorkFlow.workflowItems = result;
                editWorkFlow.initializeDataTable();
            }
        );
    },
    initializeDataTable: function () {
        var contextMenuItems = [
            { "Action": "editWorkflowItem", "Label": resources.Properties },
            { "Action": "deleteWorkflowItems", "Label": resources.Delete }];

        var toolBarItems = [
            { "Action": "new", "Label": resources.New, "DisplayMode": dataTables.itemDisplayMode.always },
            { "Action": "delete", "Label": resources.Delete }
        ];

        editWorkFlow.datatable = $(".h-EditWorkflowItemsTable", editWorkFlow.context).a4datatable({
            lengthMenu: [8, 10, 20, 50],
            displayLength: 8,
            serverSide: false,
            data: editWorkFlow.workflowItems,
            columns: [
                { "Title": resources.Id, "Data": "Id", "Key": true, "Visible": false },
                { "Title": resources.Priority, "Data": "Priority" },
                { "Title": resources.Project, "Data": "ProjectName" },
                { "Title": resources.CatiId, "Data": "CatiModuleId", "Visible": false },
                { "Title": resources.CatiModuleName, "Data": "CatiModuleName" },
                { "Title": resources.TelephonyId, "Data": "ProntoModuleId", "Visible": false },
                { "Title": resources.ProntoModuleName, "Data": "ProntoModuleName" },
                { "Title": resources.ProntoModuleType, "Data": "ProntoModuleTypeLabel", "Visible": false },
                { "Title": resources.Group, "Data": "SampleGroup" },
                { "Title": resources.ModifyOn, "Data": "ModifyDate", "Visible": false }
            ],
            defaultSorting: "Priority",
            allowRowSelection: true,
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "delete":
                        editWorkFlow.deleteWorkflowItems(ids);
                        break;
                    case "new":
                        editWorkFlow.createWorkflowItem();
                        break;
                }
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "editWorkflowItem":
                        editWorkFlow.editWorkflowItem(row);
                        break;
                    case "deleteWorkflowItems":
                        editWorkFlow.deleteWorkflowItems([row.Id]);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchItem }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-createWorkflow", function (event) {
            a4.callServerMethod(a4.getAction("SaveWorkflow", "MultiMode", "Settings"), {
                model: {
                    Id: editWorkFlow.workflowId,
                    Name: $("#Name", editWorkFlow.context).val(),
                    WorkflowItems: editWorkFlow.workflowItems
                }
            }, function (result) {
                 modalDialog.close();
            });
        });
    },
    refreshContent: function () {
        var gridItems = _.reject(editWorkFlow.workflowItems, function (item) {
            return item.Deleted;
        });

        editWorkFlow.datatable.a4datatable("option", "data", gridItems);
    },
    deleteWorkflowItems: function (workflowItemIds) {
        modalDialog.showConfirmDelete(confirmDeleteWorkflowItemResources, function () {
            _.each(editWorkFlow.workflowItems, function (item) {
                if (_.contains(workflowItemIds, item.Id)) {
                    item.Deleted = true;
                }
            });

            editWorkFlow.refreshContent();
        }, workflowItemIds.length);
    },
    createWorkflowItem: function () {
        var params = {
            workflowId: editWorkFlow.workflowId,
            workflowName: $("#Name", editWorkFlow.context).val()
        };

        editWorkFlow.openEditWorkflowItem(params);
    },

    editWorkflowItem: function (item) {
        var params = {
            workflowId: item.WorkFlowId,
            workflowName: item.WorkFlowName,
            workflowItemId: item.Id,
            workflowItemTempId: item.TempId,
            projectId: item.ProjectId,
            projectName: item.ProjectName,
            prontoModuleId: item.ProntoModuleId,
            prontoModuleName: item.ProntoModuleName,
            prontoModuleTypeId: item.ProntoModuleTypeId,
            catiModuleId: item.CatiModuleId,
            catiModuleName: item.CatiModuleName,
            priority: item.Priority,
            sampleGroup: item.SampleGroup,
            sampleAssignmentMode: item.SampleAssignmentMode,
            isSystemModule: item.IsSystemModule,
            prontoBlendProjectIdAssociated: item.ProntoBlendProjectIdAssociated
        };

        editWorkFlow.openEditWorkflowItem(params);
    },
    openEditWorkflowItem: function (params) {
        modalDialog.showWindow(a4.getAction("EditWorkflowItem", "MultiMode", "Settings", params), 450, 820, {
            beforeClose: function () {
                if (window.workflowItemData && window.workflowItemData.saved) {
                    var workflowItem = window.workflowItemData.workflowItem;

                    if (workflowItem.TempId == 0) {
                        workflowItem.TempId = editWorkFlow.workflowItems.length + 1;
                    }
                    else {
                        editWorkFlow.workflowItems = _.reject(editWorkFlow.workflowItems, function (item) {
                            return item.TempId == workflowItem.TempId;
                        });
                    }

                    editWorkFlow.workflowItems.push(workflowItem);

                    editWorkFlow.refreshContent();
                }
            }
        });
    }
};

$(document).ready(function () {
    if (editWorkFlow.context.length > 0) {
        editWorkFlow.initialize();
        editWorkFlow.bindEvents();
    }
});